USE [{DBName}]

BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT

BEGIN TRANSACTION

BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT

BEGIN TRANSACTION

IF NOT EXISTS (SELECT * FROM sysobjects WHERE [name] = 'qi_ReindexDB')
BEGIN
EXEC sp_executesql N'
-- reorganize 10-30%, rebuild > 30%
create procedure {DBOwner}[qi_ReindexDB] @fillfactor int as
begin
	set nocount on
	declare @objname nvarchar(130)
	declare @indname nvarchar(130)
	declare @fragper float
	declare @command nvarchar(max);     
    
	select object_name(i.object_id) AS ''tablename'',i.name as ''indexname'',avg_fragmentation_in_percent
	into #fragindexes 
	from sys.indexes as i 
		join sys.objects as o on i.object_id = o.object_id
		left outer join sys.dm_db_index_physical_stats (db_id(),NULL,NULL,NULL,''LIMITED'') as u on u.object_id = i.object_id AND u.index_id = i.index_id 
	where (objectproperty(i.object_id,''IsUserTable'') = 1) and (i.index_id > 0) and (u.avg_fragmentation_in_percent > 10.0)

	declare frag scroll cursor for select * from #fragindexes
	open frag
	fetch first from frag into @objname,@indname,@fragper
	while (@@fetch_status = 0)
	begin
		-- 30 is an arbitrary decision point at which to switch between reorganizing and rebuilding
		if @fragper > 30.0
		begin
		if @fillfactor > 0
			set @command = N''alter index '' + @indname + N'' on '' + @objname + N'' rebuild with (fillfactor = '' + convert(nvarchar(20),@fillfactor) + N'', MAXDOP = 1)''
		else
			set @command = N''alter index '' + @indname + N'' on '' + @objname + N'' rebuild with (MAXDOP = 1)''
		end
		else
		set @command = N''alter index '' + @indname + N'' on '' + @objname + N'' reorganize''
           
		exec(@command);  
		fetch next from frag into @objname,@indname,@fragper
	end
	close frag
	deallocate frag
	drop table #fragindexes
	set nocount off
end
'
END

GO
COMMIT

BEGIN TRY
  EXEC {DBOwner}[qi_ReindexDB] 80
END TRY
BEGIN CATCH
  -- ignore, probably permissions missing
END CATCH


BEGIN TRY
  EXEC sp_updatestats
END TRY
BEGIN CATCH
  -- ignore, probably permissions missing
END CATCH

GO
